Ext.data.JsonP.sol_checklist_ix_services_Checklist({"tagname":"class","name":"sol.checklist.ix.services.Checklist","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.checklist.ix.services.Checklist.js","href":"sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.00.000"],"eloix":true,"requires":["moment.js","sol.common.Config","sol.common.DateUtils","sol.common.SordUtils","sol.common.ix.RfUtils","sol.common.ix.ServiceBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"uses":[],"members":[{"name":"objId","tagname":"cfg","owner":"sol.common.ix.ServiceBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.checklist.ix.services.Checklist","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"STATUS","tagname":"property","owner":"sol.checklist.ix.services.Checklist","id":"property-STATUS","meta":{"private":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"sordZ","tagname":"property","owner":"sol.checklist.ix.services.Checklist","id":"property-sordZ","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"addItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-addItem","meta":{}},{"name":"buildResponse","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-buildResponse","meta":{"private":true}},{"name":"checkItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-checkItem","meta":{}},{"name":"checkItemObject","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-checkItemObject","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"createUser","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-createUser","meta":{"private":true}},{"name":"editChecklist","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-editChecklist","meta":{"private":true}},{"name":"editItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-editItem","meta":{}},{"name":"getItemIndex","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-getItemIndex","meta":{"private":true}},{"name":"hasWriteAccess","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-hasWriteAccess","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-initialize","meta":{"private":true}},{"name":"markItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-markItem","meta":{}},{"name":"mergeItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-mergeItem","meta":{"private":true}},{"name":"moveItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-moveItem","meta":{}},{"name":"moveItemInArray","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-moveItemInArray","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-process","meta":{"abstract":true}},{"name":"readChecklist","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-readChecklist","meta":{}},{"name":"removeItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-removeItem","meta":{}},{"name":"saveChecklist","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-saveChecklist","meta":{"private":true}},{"name":"validateItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"method-validateItem","meta":{"private":true}},{"name":"RF_sol_checklist_service_AddItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_AddItem","meta":{"static":true}},{"name":"RF_sol_checklist_service_CheckItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_CheckItem","meta":{"static":true}},{"name":"RF_sol_checklist_service_EditChecklist","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_EditChecklist","meta":{"static":true}},{"name":"RF_sol_checklist_service_EditItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_EditItem","meta":{"static":true}},{"name":"RF_sol_checklist_service_MarkItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_MarkItem","meta":{"static":true}},{"name":"RF_sol_checklist_service_MoveItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_MoveItem","meta":{"static":true}},{"name":"RF_sol_checklist_service_ReadChecklist","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_ReadChecklist","meta":{"static":true}},{"name":"RF_sol_checklist_service_RemoveItem","tagname":"method","owner":"sol.checklist.ix.services.Checklist","id":"static-method-RF_sol_checklist_service_RemoveItem","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.checklist.ix.services.Checklist","short_doc":"Provides service functions for the checklist module. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.checklist.ix.services.Checklist</strong></div></div></div><h4>Requires</h4><div class='dependency'>moment.js</div><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist' target='_blank'>sol.checklist.ix.services.Checklist.js</a></div></pre><div class='doc-contents'><p>Provides service functions for the checklist module.</p>\n\n<p>The element used as checklist, has to define a <code>SOL_TYPE</code> field with the value from the checklist configuration defined in <code>checklist.solObjectType</code>.</p>\n\n<h1>Model</h1>\n\n<p>The model of the checklist is stored in the description of a sord as JSON string.</p>\n\n<p>A checklist contains an <code>items</code> property which holds an array of checklist items.</p>\n\n<p>Each checklist item has the following form:</p>\n\n<pre><code>{\n  id: 23,\n  text: \"a label\",\n  notes: \"a description\",                      // optional\n  checked: true,\n  checkDate: \"20160824113000\",                 // only set, if checked=true\n  checkUser: { id: \"7\", name: \"mmustermann\" }, // only set, if checked=true\n  marked: false\n}\n</code></pre>\n\n<h1>Results</h1>\n\n<p>All function (except <a href=\"#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_ReadChecklist\" rel=\"sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_ReadChecklist\" class=\"docClass\">ReadChecklist</a>) return a standardized response format:</p>\n\n<pre><code>{\n  status: \"SUCCESS\"        // possible values: SUCCESS|FAILURE|RECURRENCE\n  item: {...}              // optional, e.g. added, removed, updated item\n  error: \"some.error.code\" // only if 'status' is 'FAILURE'\n}\n</code></pre>\n\n<h2>Errorcodes</h2>\n\n<table>\n<thead>\n<tr>\n<th style=\"text-align:left;\">Code</th>\n<th style=\"text-align:left;\">Description</th>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td style=\"text-align:left;\">checklist.save</td>\n<td style=\"text-align:left;\">Error while saving checklist</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.item.invalid</td>\n<td></td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.item.notFound</td>\n<td style=\"text-align:left;\">Item not found</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.item.notMoved</td>\n<td style=\"text-align:left;\">Item not moved</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.missing.itemId</td>\n<td style=\"text-align:left;\">Missing property 'itemId'</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.missing.check</td>\n<td style=\"text-align:left;\">Missing property 'check'</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.missing.mark</td>\n<td style=\"text-align:left;\">Missing property 'mark'</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.missing.item.id</td>\n<td style=\"text-align:left;\">Edit item has not defined an 'id'</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.missing.fromIdx</td>\n<td style=\"text-align:left;\">Missing property 'fromIdx'</td>\n</tr>\n<tr>\n<td style=\"text-align:left;\">checklist.missing.toIdx</td>\n<td style=\"text-align:left;\">Missing property 'toIdx'</td>\n</tr>\n</tbody>\n</table>\n\n\n<h1>Usage</h1>\n\n<h2>Edit checklist</h2>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_EditChecklist\", { objId: \"4711\",  checklistname: \"checklist4711\", checklistdesc: \"Water cologne\" });\n\n// result //\n{\n  status: \"SUCCESS\"\n}\n</code></pre>\n\n<h2>Read checklist</h2>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_ReadChecklist\", { objId: \"4711\" });\n\n// result //\n{\n  items: [ ... ],\n  writable: true\n}\n</code></pre>\n\n<h2>Move an checklist item</h2>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_MoveItem\", {\n  objId: \"4711\",\n  fromIdx: 2,\n  toIdx: 4\n});\n\n// result (the added item) //\n{\n  status: \"SUCCESS\"\n}\n</code></pre>\n\n<h2>Add checklist item</h2>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_AddItem\", {\n  objId: \"4711\",\n  item: {\n    text: \"a label\",\n    notes: \"optional description\"\n  }\n});\n\n// result (the added item) //\n{\n  status: \"SUCCESS\",\n  item: {\n    id: 23,\n    text: \"a label\",\n    notes: \"optional description\",\n    checked: false,\n    marked: false\n  }\n}\n</code></pre>\n\n<h2>Remove checklist item</h2>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_RemoveItem\", {\n  objId: \"4711\",\n  itemId: 23\n});\n\n// result (including the removed item) //\n{\n  status: \"SUCCESS\",\n  item: {\n    id: 23,\n    text: \"a label\",\n    notes: \"optional description\",\n    checked: false,\n    marked: false\n  }\n}\n</code></pre>\n\n<h2>Edit checklist item</h2>\n\n<p>Only <code>text</code> and <code>notes</code> can be edited this way.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_EditItem\", {\n  objId: \"4711\",\n  item: {\n    id: 23,\n    text: \"an edited label\",\n    notes: \"edit\"\n  }\n});\n\n// result //\n{\n  status: \"SUCCESS\",\n  item: {\n    id: 23,\n    text: \"an edited label\",\n    notes: \"edit\",\n    checked: false,\n    marked: false\n  }\n}\n</code></pre>\n\n<h2>Check checklist item</h2>\n\n<p>Check an item:</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_CheckItem\", {\n  objId: \"4711\",\n  itemId: 23,\n  check: true\n});\n\n// result //\n{\n  status: \"SUCCESS\",\n  item: {\n    id: 23,\n    text: \"a label\",\n    notes: \"optional description\",\n    checked: true,\n    checkDate: \"20160824113000\",\n    checkUser: { id: \"7\", name: \"mmustermann\" },\n    marked: false\n  }\n}\n</code></pre>\n\n<p>Uncheck an item:</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_CheckItem\", {\n  objId: \"4711\",\n  itemId: 23,\n  check: false\n});\n\n// result //\n{\n  status: \"SUCCESS\",\n  item: {\n    id: 23,\n    text: \"a label\",\n    notes: \"optional description\",\n    checked: false,\n    marked: false\n  }\n}\n</code></pre>\n\n<p>Uncheck again:</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_CheckItem\", {\n  objId: \"4711\",\n  itemId: 23,\n  check: false\n});\n\n// result, item was not altered, but will be returned anyway (it might have been altered by another user) //\n{\n  status: \"RECURRENCE\",\n  item: {\n    id: 23,\n    text: \"a label\",\n    notes: \"optional description\",\n    checked: false,\n    marked: false\n  }\n}\n</code></pre>\n\n<h2>Mark checklist item</h2>\n\n<p>Mark an item:</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_MarkItem\", {\n  objId: \"4711\",\n  itemId: 23,\n  mark: true\n});\n</code></pre>\n\n<p>Unmark an item:</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_checklist_service_MarkItem\", {\n  objId: \"4711\",\n  itemId: 23,\n  mark: false\n});\n</code></pre>\n\n<p>Results equivalent to checking and unchecking.</p>\n      <p class='version-tag'>Version: <b>1.00.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-objId' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-STATUS' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-property-STATUS' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-property-STATUS' class='name expandable'>STATUS</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{SUCCESS: &quot;SUCCESS&quot;, FAILURE: &quot;FAILURE&quot;, RECURRENCE: &quot;RECURRENCE&quot;}</code></p></div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-sordZ' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-property-sordZ' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-property-sordZ' class='name expandable'>sordZ</a> : de.elo.ix.client.SordZ<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-addItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-addItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-addItem' class='name expandable'>addItem</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Adds an item to a checklist. ...</div><div class='long'><p>Adds an item to a checklist.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-buildResponse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-buildResponse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-buildResponse' class='name expandable'>buildResponse</a>( <span class='pre'>status, [item], [error]</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds the response object. ...</div><div class='long'><p>Builds the response object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>status</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>item</span> : Object (optional)<div class='sub-desc'>\n</div></li><li><span class='pre'>error</span> : String (optional)<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-checkItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-checkItem' class='name expandable'>checkItem</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Marks an item as checked/unchecked and handles the checkUser and checkDate attributes. ...</div><div class='long'><p>Marks an item as checked/unchecked and handles the <code>checkUser</code> and <code>checkDate</code> attributes.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkItemObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-checkItemObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-checkItemObject' class='name expandable'>checkItemObject</a>( <span class='pre'>item, check, [user]</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, or unchecks an item. ...</div><div class='long'><p>Checks, or unchecks an item.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>check</span> : Boolean<div class='sub-desc'>\n</div></li><li><span class='pre'>user</span> : de.elo.ix.client.UserInfo (optional)<div class='sub-desc'><p>only required if <code>check</code> is <code>true</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-createUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-createUser' class='name expandable'>createUser</a>( <span class='pre'>user</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates a user representation. ...</div><div class='long'><p>Creates a user representation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>user</span> : de.elo.ix.client.UserInfo<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>A user representation</p>\n<ul><li><span class='pre'>id</span> : String<div class='sub-desc'><p>The user id</p>\n</div></li><li><span class='pre'>name</span> : String<div class='sub-desc'><p>The ELO user name</p>\n</div></li></ul></div></li></ul></div></div></div><div id='method-editChecklist' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-editChecklist' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-editChecklist' class='name expandable'>editChecklist</a>( <span class='pre'>checklist</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Edits a checklist ...</div><div class='long'><p>Edits a checklist</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>checklist</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-editItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-editItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-editItem' class='name expandable'>editItem</a>( <span class='pre'></span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Edits an item of a checklist. ...</div><div class='long'><p>Edits an item of a checklist.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getItemIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-getItemIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-getItemIndex' class='name expandable'>getItemIndex</a>( <span class='pre'>checklist, id</span> ) : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the index of an item by the ID. ...</div><div class='long'><p>Retrieves the index of an item by the ID.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>checklist</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>id</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasWriteAccess' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-hasWriteAccess' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-hasWriteAccess' class='name expandable'>hasWriteAccess</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks, if a sord was checked out with write access. ...</div><div class='long'><p>Checks, if a sord was checked out with write access.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-initialize\" rel=\"sol.common.ix.ServiceBase-method-initialize\" class=\"docClass\">sol.common.ix.ServiceBase.initialize</a></p></div></div></div><div id='method-markItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-markItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-markItem' class='name expandable'>markItem</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Marks an item as marked. ...</div><div class='long'><p>Marks an item as marked.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mergeItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-mergeItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-mergeItem' class='name expandable'>mergeItem</a>( <span class='pre'>dst, src</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Merges an item to another. ...</div><div class='long'><p>Merges an item to another.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dst</span> : Object<div class='sub-desc'><p>Destination item</p>\n</div></li><li><span class='pre'>src</span> : Object<div class='sub-desc'><p>Source item</p>\n</div></li></ul></div></div></div><div id='method-moveItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-moveItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-moveItem' class='name expandable'>moveItem</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Moves an item. ...</div><div class='long'><p>Moves an item.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The checklist</p>\n</div></li></ul></div></div></div><div id='method-moveItemInArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-moveItemInArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-moveItemInArray' class='name expandable'>moveItemInArray</a>( <span class='pre'>items, fromIdx, toIdx</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Moves an element inside an array from one position to another. ...</div><div class='long'><p>Moves an element inside an array from one position to another.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>items</span> : Object[]<div class='sub-desc'>\n</div></li><li><span class='pre'>fromIdx</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>toIdx</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"><span class='abstract' >abstract</span></span></div><div class='description'><div class='short'>Implementation of services' process. ...</div><div class='long'><p>Implementation of services' process. This function must be implemented by the child class and should contain the logic of the function module.</p>\n</div></div></div><div id='method-readChecklist' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-readChecklist' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-readChecklist' class='name expandable'>readChecklist</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads the checklist object from the description of a Sord. ...</div><div class='long'><p>Loads the checklist object from the description of a Sord.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>The checklist</p>\n</div></li></ul></div></div></div><div id='method-removeItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-removeItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-removeItem' class='name expandable'>removeItem</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Removes an item from a checklist. ...</div><div class='long'><p>Removes an item from a checklist.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-saveChecklist' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-saveChecklist' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-saveChecklist' class='name expandable'>saveChecklist</a>( <span class='pre'>checklist</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Saves a checklist ...</div><div class='long'><p>Saves a checklist</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>checklist</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-validateItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-method-validateItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-method-validateItem' class='name expandable'>validateItem</a>( <span class='pre'>item</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Checks if an item is valid. ...</div><div class='long'><p>Checks if an item is valid.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_checklist_service_AddItem' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_AddItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_AddItem' class='name expandable'>RF_sol_checklist_service_AddItem</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_checklist_service_CheckItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_CheckItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_CheckItem' class='name expandable'>RF_sol_checklist_service_CheckItem</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_checklist_service_EditChecklist' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_EditChecklist' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_EditChecklist' class='name expandable'>RF_sol_checklist_service_EditChecklist</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_checklist_service_EditItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_EditItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_EditItem' class='name expandable'>RF_sol_checklist_service_EditItem</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_checklist_service_MarkItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_MarkItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_MarkItem' class='name expandable'>RF_sol_checklist_service_MarkItem</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_checklist_service_MoveItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_MoveItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_MoveItem' class='name expandable'>RF_sol_checklist_service_MoveItem</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_checklist_service_ReadChecklist' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_ReadChecklist' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_ReadChecklist' class='name expandable'>RF_sol_checklist_service_ReadChecklist</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div><div id='static-method-RF_sol_checklist_service_RemoveItem' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.checklist.ix.services.Checklist'>sol.checklist.ix.services.Checklist</span><br/><a href='source/sol.checklist.ix.services.Checklist.html#sol-checklist-ix-services-Checklist-static-method-RF_sol_checklist_service_RemoveItem' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.checklist.ix.services.Checklist-static-method-RF_sol_checklist_service_RemoveItem' class='name expandable'>RF_sol_checklist_service_RemoveItem</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n\n\n\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n\n\n\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});